/*
 * Decompiled with CFR 0.152.
 */
package resources;

import backend.Database;
import backend.Player;
import backend.Resource;
import engines.DepthEngine;
import engines.FileDatabase;
import engines.FileDepthEngine;
import engines.FileFixedEngine;
import engines.Synergy2PRO;
import engines.elephant.Elephant;
import engines.nuwanisl.NuwaniSL;
import frontend.VolatileLogger;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import resources.Resources;

public class EngineSourceManager {
    private static final String LOCATIONSFILENAME = "locations.txt";
    private static final File locationsfile;
    private static final List<File> locations;
    private static final List<Player> BUILTINENGINES;
    private static int lastAmountOfResources;

    public static void collectResources(ArrayList<Player> playerList, ArrayList<Database> dbList, Player ... extraResources) {
        playerList.ensureCapacity(lastAmountOfResources);
        Stack<File> walkerstack = new Stack<File>();
        for (File loc : locations) {
            walkerstack.push(loc);
            while (!walkerstack.isEmpty()) {
                File dir = (File)walkerstack.pop();
                if (!dir.isDirectory()) continue;
                for (File child : dir.listFiles()) {
                    String name;
                    int dotloc;
                    if (child.isDirectory()) {
                        walkerstack.push(child);
                        continue;
                    }
                    if (!child.isFile() || (dotloc = (name = child.getName()).lastIndexOf(46)) == -1) continue;
                    String extension = name.substring(dotloc);
                    if (".ak".equals(extension)) {
                        EngineSourceManager.addResource(playerList, new FileFixedEngine(child));
                        continue;
                    }
                    if (".akb".equals(extension)) {
                        EngineSourceManager.addResource(playerList, new FileDepthEngine(child));
                        continue;
                    }
                    if (!".adb".equals(extension)) continue;
                    EngineSourceManager.addResource(dbList, new FileDatabase(child));
                }
            }
        }
        int bpos = 0;
        for (Player extraResource : extraResources) {
            playerList.add(bpos++, extraResource);
        }
        playerList.addAll(bpos, BUILTINENGINES);
        lastAmountOfResources = playerList.size() + 20;
    }

    public static Database tryFindDatabaseFor(Player player, ArrayList<Database> databases) throws Exception {
        if (player.canUseDatabase()) {
            for (Database database : databases) {
                if (!database.getName().equals(player.getName())) continue;
                database.load();
                return database;
            }
        }
        return null;
    }

    private static <T extends Resource> void addResource(List<T> list, T resource) {
        if (list.isEmpty()) {
            list.add(resource);
            return;
        }
        String name = resource.getName().toLowerCase();
        int min = 0;
        int max = list.size();
        int pos = max / 2;
        do {
            String othername;
            if (name.compareTo(othername = ((Resource)list.get(pos)).getName().toLowerCase()) >= 0) {
                min = pos + 1;
            } else {
                max = pos;
            }
            if (max - min >= 1) continue;
            pos = max;
            break;
        } while ((pos = (max + min) / 2) < list.size());
        list.add(pos, resource);
    }

    private static void readLocations() {
        locations.clear();
        if (!locationsfile.exists()) {
            return;
        }
        try {
            List<String> lines = Files.readAllLines(locationsfile.toPath());
            for (String line : lines) {
                File file = Resources.ptof(line);
                if (file == null) continue;
                locations.add(file);
            }
        }
        catch (IOException e) {
            VolatileLogger.logf(e, "reading %s file", LOCATIONSFILENAME);
        }
    }

    public static List<File> getLocations() {
        return new ArrayList<File>(locations);
    }

    public static void setLocations(List<File> locations) {
        EngineSourceManager.locations.clear();
        EngineSourceManager.locations.addAll(locations);
        ArrayList<String> lines = new ArrayList<String>();
        for (File file : locations) {
            lines.add(file.getAbsolutePath());
        }
        try {
            Files.write(locationsfile.toPath(), lines, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (IOException e) {
            VolatileLogger.logf(e, "writing %s file", LOCATIONSFILENAME);
        }
    }

    static {
        lastAmountOfResources = 100;
        locationsfile = new File(Resources.workingdir, LOCATIONSFILENAME);
        locations = new ArrayList<File>();
        EngineSourceManager.readLocations();
        BUILTINENGINES = new ArrayList<Player>();
        BUILTINENGINES.add(new DepthEngine("sYnergY 1", 6, 6, 6, 6, 6, 6, 6, 6));
        BUILTINENGINES.add(Synergy2PRO.INSTANCE);
        BUILTINENGINES.add(new DepthEngine("sYnergY 3", 9, 6, 9, 8, 7, 6, 7, 8));
        BUILTINENGINES.add(NuwaniSL.INSTANCE);
        BUILTINENGINES.add(Elephant.INSTANCE);
        BUILTINENGINES.add(new DepthEngine("Junior", 9, 8, 7, 6, 9, 6, 7, 8));
        BUILTINENGINES.add(new DepthEngine("GreenFrog", 8, 8, 8, 8, 6, 8, 9, 9));
        BUILTINENGINES.add(new DepthEngine("Jaguar", 8, 8, 7, 7, 6, 6, 8, 7));
        BUILTINENGINES.add(new DepthEngine("Red", 7, 6, 9, 7, 6, 8, 8, 7));
        BUILTINENGINES.add(new DepthEngine("Deep Red", 9, 9, 8, 7, 7, 8, 6, 7));
        BUILTINENGINES.add(new DepthEngine("Derp", 8, 6, 8, 7, 7, 6, 8, 8));
        BUILTINENGINES.add(new DepthEngine("Schildpad", 9, 9, 9, 9, 9, 9, 9, 9));
        BUILTINENGINES.add(new DepthEngine("Botje 2 PRO", 9, 7, 8, 7, 8, 7, 9, 7));
    }
}

