/*
 * Decompiled with CFR 0.152.
 */
package frontend.maincontent;

import backend.Game;
import frontend.Main;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JPanel;

public class BigCardsDisplay
extends JPanel {
    private static final int PADDING = 16;
    private Game game;

    public BigCardsDisplay(Game game) {
        this.game = game;
        Dimension dim = new Dimension(new Dimension(776, 196));
        this.setMinimumSize(dim);
        this.setPreferredSize(dim);
    }

    @Override
    protected void paintComponent(Graphics g) {
        Dimension size = this.getSize();
        Dimension minSize = this.getMinimumSize();
        g.setColor(this.getBackground());
        g.fillRect(0, 0, size.width, size.height);
        int minx = (size.width - minSize.width) / 2;
        int miny = (size.height - minSize.height) / 2;
        g.setColor(Color.black);
        int move = this.game.data == null ? 0 : this.game.data.getCurrentMove();
        for (int i = 0; i < 9; ++i) {
            int x = minx + 72 * i + 16 * i;
            int y = miny;
            g.drawRect(x, y, 71, 89);
            if (i < move) {
                g.drawImage(Main.bigElementImages[this.game.data.getMove(0, i)], x + 1, y + 1, null);
            } else if (i == 0) {
                g.drawImage(Main.backImage, x + 1, y + 1, null);
            }
            y = miny + 88 + 2 + 16;
            g.drawRect(x, y, 71, 89);
            if (i < move) {
                g.drawImage(Main.bigElementImages[this.game.data.getMove(1, i)], x + 1, y + 1, null);
                continue;
            }
            if (i != 0) continue;
            g.drawImage(Main.backImage, x + 1, y + 1, null);
        }
    }
}

