/*
 * Decompiled with CFR 0.152.
 */
package frontend.dialogs;

import backend.Database;
import backend.Player;
import frontend.util.SwingMsg;
import frontend.util.SwingUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import resources.EngineSourceManager;
import resources.Settings;

public class LocationDialog {
    private static final String SETTING_LAST_ACCESSED_FOLDER = "locationdialog.laf";

    public static void show(Window parentWindow) {
        JDialog dialog = new JDialog(parentWindow);
        final List<File> locationList = EngineSourceManager.getLocations();
        final ArrayList listDataListeners = new ArrayList();
        JList<Object> list = new JList<Object>();
        list.setModel(new ListModel<File>(){

            @Override
            public int getSize() {
                return locationList.size();
            }

            @Override
            public File getElementAt(int index) {
                return (File)locationList.get(index);
            }

            @Override
            public void addListDataListener(ListDataListener l) {
                listDataListeners.add(l);
            }

            @Override
            public void removeListDataListener(ListDataListener l) {
                listDataListeners.remove(l);
            }
        });
        list.setCellRenderer(new DefaultListCellRenderer());
        if (!locationList.isEmpty()) {
            list.setSelectedIndex(0);
        }
        JScrollPane scrollpane = new JScrollPane(list);
        scrollpane.setHorizontalScrollBarPolicy(30);
        scrollpane.setVerticalScrollBarPolicy(20);
        scrollpane.setPreferredSize(new Dimension(550, 300));
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 1;
        c.anchor = 11;
        c.fill = 2;
        JPanel pnlListControl = new JPanel(new GridBagLayout());
        JButton btnAdd = new JButton("+");
        JButton btnRemove = new JButton("-");
        btnAdd.addActionListener(e -> {
            JFileChooser fc = new JFileChooser();
            String laf = Settings.settings.getProperty(SETTING_LAST_ACCESSED_FOLDER, null);
            if (laf != null) {
                fc.setCurrentDirectory(new File(laf));
            }
            fc.setDialogTitle("Choose a directory");
            fc.setFileSelectionMode(1);
            fc.setAcceptAllFileFilterUsed(false);
            if (fc.showOpenDialog(dialog) != 0) {
                return;
            }
            File file = fc.getSelectedFile();
            if (file == null) {
                return;
            }
            if (file.exists() && file.isDirectory()) {
                File pf = file.getParentFile();
                if (pf != null) {
                    Settings.settings.setProperty(SETTING_LAST_ACCESSED_FOLDER, pf.getAbsolutePath());
                    Settings.save();
                }
                locationList.add(file);
                for (ListDataListener l : listDataListeners) {
                    l.contentsChanged(new ListDataEvent(btnRemove, 2, locationList.size() - 1, locationList.size() - 1));
                }
            }
        });
        btnRemove.addActionListener(e -> {
            int idx = list.getSelectedIndex();
            if (0 <= idx && idx < locationList.size()) {
                locationList.remove(idx);
                for (ListDataListener l : listDataListeners) {
                    l.contentsChanged(new ListDataEvent(btnRemove, 2, idx, idx));
                }
            }
        });
        pnlListControl.add((Component)btnAdd, c);
        ++c.gridy;
        pnlListControl.add((Component)btnRemove, c);
        ++c.gridy;
        c.weighty = 1.0;
        pnlListControl.add((Component)new JLabel(), c);
        JPanel pnlMain = new JPanel(new BorderLayout());
        pnlMain.add((Component)pnlListControl, "West");
        pnlMain.add(scrollpane);
        JPanel pnlButtons = new JPanel(new FlowLayout(1));
        JButton btnCancel = new JButton("Cancel");
        JButton btnOk = new JButton("Ok");
        btnCancel.addActionListener(e -> SwingUtil.close(dialog));
        btnOk.addActionListener(e -> {
            EngineSourceManager.setLocations(locationList);
            SwingUtil.close(dialog);
        });
        JButton btnTest = new JButton("Test");
        btnTest.addActionListener(e -> {
            int numPlayers = 0;
            int numDatabases = 0;
            StringBuilder sb = new StringBuilder();
            List<File> originalLocations = EngineSourceManager.getLocations();
            try {
                ArrayList<Player> playerList = new ArrayList<Player>();
                ArrayList<Database> dbList = new ArrayList<Database>();
                EngineSourceManager.setLocations(locationList);
                EngineSourceManager.collectResources(playerList, dbList, new Player[0]);
                for (Player player : playerList) {
                    ++numPlayers;
                    try {
                        player.load();
                    }
                    catch (Throwable t) {
                        sb.append(player.getPath() + "/" + player.getName());
                        sb.append(": ");
                        sb.append(t.toString());
                        sb.append("\n");
                    }
                }
                for (Database database : dbList) {
                    ++numDatabases;
                    try {
                        database.load();
                    }
                    catch (Throwable t) {
                        sb.append(database.getPath() + "/" + database.getName());
                        sb.append(": ");
                        sb.append(t.toString());
                        sb.append("\n");
                    }
                }
            }
            finally {
                EngineSourceManager.setLocations(originalLocations);
            }
            String prepend = String.format("Tested %d players, %d databases\n", numPlayers, numDatabases);
            if (sb.length() > 0) {
                SwingMsg.err_ok(dialog, "Test", prepend + sb.toString());
            } else {
                SwingMsg.info_ok(dialog, "Test", prepend + "ok");
            }
        });
        pnlButtons.add(btnTest);
        pnlButtons.add(btnCancel);
        pnlButtons.add(btnOk);
        dialog.getContentPane().setLayout(new BorderLayout());
        dialog.add(pnlMain);
        dialog.add((Component)pnlButtons, "South");
        dialog.setTitle("Edit locations");
        dialog.setModal(true);
        dialog.pack();
        dialog.setMinimumSize(dialog.getSize());
        dialog.setLocationRelativeTo(parentWindow);
        dialog.setVisible(true);
        dialog.dispose();
    }
}

