/*
 * Decompiled with CFR 0.152.
 */
package frontend.components;

import backend.Database;
import backend.Player;
import backend.Resource;
import backend.ResourceType;
import frontend.components.HideableList;
import frontend.components.JTextFieldWithPlaceholder;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import resources.EngineSourceManager;

public class PlayerSelector
extends JPanel
implements KeyListener,
ListSelectionListener,
ListCellRenderer<Resource>,
Runnable {
    private JList<Player> lstPlayer;
    private HideableList<Database> lstDatabase;
    private ArrayList<Player> players;
    private ArrayList<Database> databases;
    private JTextField txtFilterPlayer;
    private JTextField txtFilterDatabase;
    private JLabel[] lblPlayerTypes;
    private JLabel[] lblDatabaseTypes;
    private JPanel lstCellPnl;
    private JPanel lstCellPnlTypeColorSquare;
    private JLabel lstCellLblName;
    private JLabel lstCellLblLocation;
    private boolean updateQueued;
    private boolean needPlayerFilterUpdate;
    private boolean needDatabaseFilterUpdate;
    public Listener listener;

    public PlayerSelector(ArrayList<Player> players, ArrayList<Database> databases, Player preselectedPlayer, Database preselectedDatabase) {
        super(new GridBagLayout());
        JPanel pnl;
        int i;
        this.players = players;
        this.databases = databases;
        this.lstCellPnlTypeColorSquare = new JPanel();
        this.lstCellPnlTypeColorSquare.setPreferredSize(new Dimension(10, 10));
        this.lstCellPnlTypeColorSquare.setOpaque(true);
        this.lstCellLblName = new JLabel();
        this.lstCellLblName.setBorder(new EmptyBorder(0, 5, 0, 5));
        this.lstCellLblLocation = new JLabel();
        this.lstCellLblLocation.setForeground(new Color(0x666666));
        this.lstCellLblLocation.setBorder(new EmptyBorder(0, 5, 0, 5));
        this.lstCellPnl = new JPanel(new BorderLayout());
        this.lstCellPnl.setBorder(new MatteBorder(0, 0, 1, 0, new Color(0xEEEEEE)));
        this.lstCellPnl.setOpaque(true);
        this.lstCellPnl.add((Component)this.lstCellPnlTypeColorSquare, "West");
        this.lstCellPnl.add(this.lstCellLblName);
        this.lstCellPnl.add((Component)this.lstCellLblLocation, "East");
        JLabel lblPlayer = new JLabel("Player:");
        this.txtFilterPlayer = new JTextFieldWithPlaceholder("player filter");
        this.txtFilterPlayer.addKeyListener(this);
        this.lstPlayer = new JList(new DefaultListModel());
        this.lstPlayer.setSelectionMode(0);
        this.lstPlayer.setCellRenderer(this);
        this.lstPlayer.setFocusable(false);
        this.lstPlayer.addListSelectionListener(this);
        JScrollPane playerScroller = new JScrollPane(this.lstPlayer);
        playerScroller.setHorizontalScrollBarPolicy(30);
        playerScroller.setVerticalScrollBarPolicy(20);
        this.lblPlayerTypes = new JLabel[ResourceType.PLAYERTYPES.length];
        JPanel playerListInfo = new JPanel(new FlowLayout(1));
        for (i = 0; i < ResourceType.PLAYERTYPES.length; ++i) {
            pnl = new JPanel();
            pnl.setOpaque(true);
            pnl.setBackground(new Color(ResourceType.PLAYERTYPES[i].color));
            pnl.setPreferredSize(new Dimension(10, 10));
            playerListInfo.add(pnl);
            playerListInfo.add(new JLabel(ResourceType.PLAYERTYPES[i].name));
            this.lblPlayerTypes[i] = new JLabel();
            playerListInfo.add(this.lblPlayerTypes[i]);
        }
        JLabel lblDatabase = new JLabel("Database:");
        this.txtFilterDatabase = new JTextFieldWithPlaceholder("database filter");
        this.txtFilterDatabase.addKeyListener(this);
        this.lstDatabase = new HideableList(new DefaultListModel());
        this.lstDatabase.setSelectionMode(0);
        this.lstDatabase.setCellRenderer(this);
        this.lstDatabase.setFocusable(false);
        this.lstDatabase.addListSelectionListener(this);
        JScrollPane databaseScroller = new JScrollPane(this.lstDatabase);
        databaseScroller.setHorizontalScrollBarPolicy(30);
        databaseScroller.setVerticalScrollBarPolicy(20);
        databaseScroller.setPreferredSize(new Dimension(20, 100));
        databaseScroller.setMinimumSize(new Dimension(20, 100));
        this.lblDatabaseTypes = new JLabel[ResourceType.DATABASETYPES.length];
        JPanel databaseListInfo = new JPanel(new FlowLayout(1));
        for (i = 0; i < ResourceType.DATABASETYPES.length; ++i) {
            pnl = new JPanel();
            pnl.setOpaque(true);
            pnl.setBackground(new Color(ResourceType.DATABASETYPES[i].color));
            pnl.setPreferredSize(new Dimension(10, 10));
            databaseListInfo.add(pnl);
            databaseListInfo.add(new JLabel(ResourceType.DATABASETYPES[i].name));
            this.lblDatabaseTypes[i] = new JLabel();
            databaseListInfo.add(this.lblDatabaseTypes[i]);
        }
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        this.add((Component)lblPlayer, gbc);
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        this.add((Component)this.txtFilterPlayer, gbc);
        gbc.gridx = 1;
        gbc.gridy = 3;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.add((Component)playerScroller, gbc);
        gbc.gridx = 1;
        gbc.gridy = 4;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        this.add((Component)playerListInfo, gbc);
        gbc.gridx = 1;
        gbc.gridy = 5;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        this.add((Component)lblDatabase, gbc);
        gbc.gridx = 1;
        gbc.gridy = 6;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        this.add((Component)this.txtFilterDatabase, gbc);
        gbc.gridx = 1;
        gbc.gridy = 7;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        this.add((Component)databaseScroller, gbc);
        gbc.gridx = 1;
        gbc.gridy = 8;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        this.add((Component)databaseListInfo, gbc);
        this.setPreferredSize(new Dimension(450, 500));
        if (preselectedPlayer != null && !"Human".equals(preselectedPlayer.getName())) {
            this.txtFilterPlayer.setText(preselectedPlayer.getName());
        }
        if (preselectedDatabase != null) {
            this.txtFilterDatabase.setText(preselectedDatabase.getName());
        }
        this.updateFilter(this.lstPlayer, this.players, this.txtFilterPlayer.getText(), this.lblPlayerTypes);
        this.updateFilter(this.lstDatabase, this.databases, this.txtFilterDatabase.getText(), this.lblDatabaseTypes);
        this.lstPlayer.setSelectedValue(preselectedPlayer, true);
        this.lstDatabase.setSelectedValue(preselectedDatabase, true);
    }

    @Override
    public boolean requestFocusInWindow() {
        this.txtFilterPlayer.selectAll();
        return this.txtFilterPlayer.requestFocusInWindow();
    }

    public Player getSelectedPlayer() {
        return this.lstPlayer.getSelectedValue();
    }

    public Database getSelectedDatabase() {
        return (Database)this.lstDatabase.getSelectedValue();
    }

    private void queueUpdate() {
        if (!this.updateQueued) {
            this.updateQueued = true;
            SwingUtilities.invokeLater(this);
        }
    }

    @Override
    public void run() {
        this.updateQueued = false;
        if (this.needPlayerFilterUpdate) {
            this.needPlayerFilterUpdate = false;
            this.updateFilter(this.lstPlayer, this.players, this.txtFilterPlayer.getText(), this.lblPlayerTypes);
            if (this.txtFilterDatabase.isEnabled()) {
                this.txtFilterDatabase.setText(this.txtFilterPlayer.getText());
                this.needDatabaseFilterUpdate = true;
            }
        }
        if (this.needDatabaseFilterUpdate) {
            this.needDatabaseFilterUpdate = false;
            this.updateFilter(this.lstDatabase, this.databases, this.txtFilterDatabase.getText(), this.lblDatabaseTypes);
        }
    }

    private <T extends Resource> void updateFilter(JList<T> list, ArrayList<T> allValues, String filterValue, JLabel[] typeLabels) {
        Resource val;
        int i;
        int dbStartIndex;
        int[] typeCounts = new int[typeLabels.length];
        boolean doFilter = !(filterValue = filterValue.toLowerCase()).isEmpty();
        DefaultListModel model = (DefaultListModel)list.getModel();
        if (list == this.lstDatabase) {
            if (model.isEmpty()) {
                model.addElement(null);
            }
            dbStartIndex = 1;
        } else {
            dbStartIndex = 0;
        }
        if (doFilter) {
            for (i = dbStartIndex; i < model.getSize(); ++i) {
                val = (Resource)model.get(i);
                if (val.getName().toLowerCase().contains(filterValue)) continue;
                model.remove(i);
                --i;
            }
        }
        int nextExistingIndex = dbStartIndex;
        for (int nextAllIndex = 0; nextAllIndex < allValues.size(); ++nextAllIndex) {
            Resource nextExistingValue = null;
            if (nextExistingIndex < model.getSize()) {
                nextExistingValue = (Resource)model.get(nextExistingIndex);
            }
            val = (Resource)allValues.get(nextAllIndex);
            if (doFilter && !val.getName().toLowerCase().contains(filterValue)) continue;
            if (val != nextExistingValue) {
                if (nextExistingValue == null) {
                    model.addElement(val);
                } else {
                    model.add(nextExistingIndex, val);
                }
            }
            ++nextExistingIndex;
        }
        for (i = dbStartIndex; i < model.getSize(); ++i) {
            int n = ((Resource)model.get((int)i)).getType().index;
            typeCounts[n] = typeCounts[n] + 1;
        }
        for (i = 0; i < typeLabels.length; ++i) {
            typeLabels[i].setText("(" + typeCounts[i] + ")");
        }
        if (list.getSelectedIndex() != -1) {
            list.ensureIndexIsVisible(list.getSelectedIndex());
        }
        if (list.getSelectedValue() == null && !model.isEmpty()) {
            if (model.getSize() > 1 && model.get(0) == null) {
                list.setSelectedIndex(1);
            } else {
                list.setSelectedIndex(0);
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
        if (e.getSource() == this.txtFilterPlayer) {
            switch (e.getKeyChar()) {
                case '\n': 
                case '\r': {
                    if (this.lstPlayer.getSelectedValue() == null) {
                        return;
                    }
                    if (this.txtFilterDatabase.isEnabled()) {
                        this.txtFilterDatabase.requestFocusInWindow();
                        this.txtFilterDatabase.selectAll();
                        break;
                    }
                    if (this.listener == null) break;
                    this.listener.acceptCurrentChoices(this);
                    break;
                }
                case '\u001b': {
                    if (this.txtFilterPlayer.getText().isEmpty()) {
                        if (this.listener == null) break;
                        this.listener.requestCancel(this);
                        break;
                    }
                    this.txtFilterPlayer.setText("");
                    break;
                }
                default: {
                    this.needPlayerFilterUpdate = true;
                    this.queueUpdate();
                }
            }
            return;
        }
        if (e.getSource() == this.txtFilterDatabase) {
            switch (e.getKeyChar()) {
                case '\n': 
                case '\r': {
                    if (this.listener == null) break;
                    this.listener.acceptCurrentChoices(this);
                    break;
                }
                case '\u001b': {
                    if (this.txtFilterDatabase.getText().isEmpty()) {
                        if (this.listener == null) break;
                        this.listener.requestCancel(this);
                        break;
                    }
                    this.txtFilterDatabase.setText("");
                    break;
                }
                default: {
                    this.needDatabaseFilterUpdate = true;
                    this.queueUpdate();
                }
            }
            return;
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getSource() == this.txtFilterPlayer) {
            if (e.getKeyCode() == 38 || e.getKeyCode() == 40) {
                this.lstPlayer.dispatchEvent(e);
            }
            return;
        }
        if (e.getSource() == this.txtFilterDatabase) {
            if (e.getKeyCode() == 38 || e.getKeyCode() == 40) {
                this.lstDatabase.dispatchEvent(e);
            }
            return;
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getSource() == this.lstPlayer) {
            if (this.listener != null) {
                this.listener.selectedPlayerChanged(this);
            }
            if (this.lstPlayer.getSelectedValue() == null) {
                this.txtFilterDatabase.setEnabled(false);
                this.lstDatabase.setEnabled(false);
                this.lstDatabase.setSelectedIndex(-1);
                this.lstDatabase.hideWithMessage("No player chosen");
                this.txtFilterDatabase.setText("");
            } else if (this.lstPlayer.getSelectedValue().canUseDatabase()) {
                this.txtFilterDatabase.setEnabled(true);
                this.lstDatabase.setEnabled(true);
                this.lstDatabase.hideWithMessage(null);
                this.txtFilterDatabase.setText(this.lstPlayer.getSelectedValue().getNameWithoutExtension());
                this.needDatabaseFilterUpdate = true;
                this.queueUpdate();
            } else {
                this.txtFilterDatabase.setEnabled(false);
                this.lstDatabase.setEnabled(false);
                this.lstDatabase.setSelectedIndex(-1);
                this.lstDatabase.hideWithMessage("This player cannot use a db");
                this.txtFilterDatabase.setText("");
            }
            return;
        }
        if (e.getSource() == this.lstDatabase && this.listener != null) {
            this.listener.selectedDatabaseChanged(this);
        }
    }

    @Override
    public Component getListCellRendererComponent(JList<? extends Resource> list, Resource value, int index, boolean isSelected, boolean cellHasFocus) {
        if (isSelected) {
            this.lstCellPnl.setBackground(list.getSelectionBackground());
            this.lstCellPnl.setForeground(list.getSelectionForeground());
        } else {
            this.lstCellPnl.setBackground(list.getBackground());
            this.lstCellPnl.setForeground(list.getForeground());
        }
        if (value != null) {
            this.lstCellPnlTypeColorSquare.setBackground(new Color(value.getType().color));
            this.lstCellLblName.setText(value.getName());
            String path = value.getPath();
            if (path != null) {
                this.lstCellLblLocation.setVisible(true);
                this.lstCellLblLocation.setText(path);
                List<File> locations = EngineSourceManager.getLocations();
                for (File location : locations) {
                    String locationPath = location.getAbsolutePath();
                    if (!path.startsWith(locationPath)) continue;
                    int len = locationPath.length();
                    if (path.length() > len && (path.charAt(len) == '/' || path.charAt(len) == '\\')) {
                        this.lstCellLblLocation.setText(path.substring(len + 1));
                    } else {
                        this.lstCellLblLocation.setText(path.substring(len));
                    }
                    break;
                }
            } else {
                this.lstCellLblLocation.setVisible(false);
            }
        } else {
            this.lstCellLblName.setText("<none>");
            this.lstCellPnlTypeColorSquare.setBackground(Color.black);
        }
        return this.lstCellPnl;
    }

    public static interface Listener {
        public void requestCancel(PlayerSelector var1);

        public void acceptCurrentChoices(PlayerSelector var1);

        public void selectedPlayerChanged(PlayerSelector var1);

        public void selectedDatabaseChanged(PlayerSelector var1);
    }
}

