/*
 * Decompiled with CFR 0.152.
 */
package frontend;

import backend.Database;
import backend.Game;
import backend.Player;
import frontend.HumanPlayer;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Objects;
import java.util.zip.CRC32;
import javax.imageio.ImageIO;
import resources.EngineSourceManager;

public class PictureSavedStorage {
    private static final int PNGSTARTLEN = 33;
    private static final String KEY_GAME_MOVE = "ac.g.m";
    private static final String KEY_P1_NAME = "ac.p1.name";
    private static final String KEY_P2_NAME = "ac.p2.name";
    private static final String KEY_P1_PATH = "ac.p1.path";
    private static final String KEY_P2_PATH = "ac.p2.path";
    private static final String KEY_DB1_NAME = "ac.db1.name";
    private static final String KEY_DB2_NAME = "ac.db2.name";
    private static final String KEY_DB1_PATH = "ac.db1.path";
    private static final String KEY_DB2_PATH = "ac.db2.path";
    private static final String KEY_P1_MOVES = "ac.p1.moves";
    private static final String KEY_P2_MOVES = "ac.p2.moves";
    private static final String KEY_P1_SCORE = "ac.p1.score";
    private static final String KEY_P2_SCORE = "ac.p2.score";
    private static CRC32 crc = new CRC32();
    private static ByteArrayOutputStream arrayOutput = new ByteArrayOutputStream(50000);

    private static void tEXt(OutputStream os, String strKey, String strValue) throws Exception {
        byte[] key = strKey.getBytes(StandardCharsets.US_ASCII);
        byte[] value = strValue == null ? new byte[]{} : strValue.getBytes(StandardCharsets.UTF_8);
        byte[] data = new byte[4 + key.length + 1 + value.length + 4];
        int len = key.length + 1 + value.length;
        data[0] = (byte)(len >>> 24 & 0xFF);
        data[1] = (byte)(len >>> 16 & 0xFF);
        data[2] = (byte)(len >>> 8 & 0xFF);
        data[3] = (byte)(len & 0xFF);
        data[4] = 116;
        data[5] = 69;
        data[6] = 88;
        data[7] = 116;
        System.arraycopy(key, 0, data, 8, key.length);
        data[8 + key.length] = 0;
        System.arraycopy(value, 0, data, 9 + key.length, value.length);
        crc.reset();
        crc.update(data, 4, 4 + len);
        os.write(data, 0, 8 + len);
        len = (int)crc.getValue();
        os.write(len >>> 24 & 0xFF);
        os.write(len >>> 16 & 0xFF);
        os.write(len >>> 8 & 0xFF);
        os.write(len & 0xFF);
    }

    public static void saveGameStateInPng(BufferedImage image, Game game, File file) throws Exception {
        arrayOutput.reset();
        ImageIO.write((RenderedImage)image, "png", arrayOutput);
        byte[] pngdata = arrayOutput.toByteArray();
        if (pngdata.length < 33) {
            throw new Exception("generated image is corrupted");
        }
        char[] moves = new char[9];
        try (FileOutputStream os = new FileOutputStream(file, false);){
            int i;
            os.write(pngdata, 0, 33);
            PictureSavedStorage.tEXt(os, KEY_GAME_MOVE, String.valueOf(game.data.getCurrentMove()));
            PictureSavedStorage.tEXt(os, KEY_P1_NAME, game.p1.getName());
            PictureSavedStorage.tEXt(os, KEY_P2_NAME, game.p2.getName());
            PictureSavedStorage.tEXt(os, KEY_P1_PATH, game.p1.getPath());
            PictureSavedStorage.tEXt(os, KEY_P2_PATH, game.p2.getPath());
            if (game.db1 != null) {
                PictureSavedStorage.tEXt(os, KEY_DB1_NAME, game.db1.getName());
                PictureSavedStorage.tEXt(os, KEY_DB1_PATH, game.db1.getPath());
            }
            if (game.db2 != null) {
                PictureSavedStorage.tEXt(os, KEY_DB2_NAME, game.db2.getName());
                PictureSavedStorage.tEXt(os, KEY_DB2_PATH, game.db2.getPath());
            }
            for (i = 0; i < game.data.getCurrentMove(); ++i) {
                moves[i] = (char)game.data.getMove(0, i);
            }
            PictureSavedStorage.tEXt(os, KEY_P1_MOVES, new String(moves, 0, game.data.getCurrentMove()));
            for (i = 0; i < game.data.getCurrentMove(); ++i) {
                moves[i] = (char)game.data.getMove(1, i);
            }
            PictureSavedStorage.tEXt(os, KEY_P2_MOVES, new String(moves, 0, game.data.getCurrentMove()));
            PictureSavedStorage.tEXt(os, KEY_P1_SCORE, String.valueOf(game.data.getScore(0)));
            PictureSavedStorage.tEXt(os, KEY_P2_SCORE, String.valueOf(game.data.getScore(1)));
            os.write(pngdata, 33, pngdata.length - 33);
        }
    }

    public static String loadGameStateFromPng(Game game, File file) throws Exception {
        String dbname;
        String path;
        int i;
        HashMap<String, String> data = new HashMap<String, String>();
        byte[] buf = new byte[1000];
        try (FileInputStream is = new FileInputStream(file);){
            if (is.read(buf, 0, 33) != 33) {
                throw new Exception("unexpected EOF");
            }
            while (is.available() > 0) {
                int len = 0;
                if (is.read(buf, 0, 4) != 4) {
                    throw new Exception("unexpected EOF");
                }
                len |= buf[0] << 24;
                len |= buf[1] << 16;
                len |= buf[2] << 8;
                len |= buf[3];
                if (is.read(buf, 0, 4) != 4) {
                    throw new Exception("unexpected EOF");
                }
                if (buf[0] != 116 || buf[1] != 69 || buf[2] != 88) break;
                if (buf[3] != 116) {
                    break;
                }
                if (is.read(buf, 0, len) != len) {
                    throw new Exception("unexpected EOF");
                }
                for (int i2 = 0; i2 < len; ++i2) {
                    if (buf[i2] != 0) continue;
                    String key = new String(buf, 0, i2, StandardCharsets.US_ASCII);
                    String value = new String(buf, i2 + 1, len - i2 - 1, StandardCharsets.UTF_8);
                    data.put(key, value);
                }
                if (is.read(buf, 0, 4) == 4) continue;
                throw new Exception("unexpected EOF");
            }
        }
        if (data.size() == 0) {
            throw new Exception("No data!");
        }
        if (!data.containsKey(KEY_GAME_MOVE)) {
            throw new Exception("Amount of moves is not present!");
        }
        if (!data.containsKey(KEY_P1_NAME)) {
            throw new Exception("Player 1 name is not present!");
        }
        if (!data.containsKey(KEY_P2_NAME)) {
            throw new Exception("Player 2 name is not present!");
        }
        if (!data.containsKey(KEY_P1_MOVES)) {
            throw new Exception("Player 1 moves are not present!");
        }
        if (!data.containsKey(KEY_P2_MOVES)) {
            throw new Exception("Player 2 moves are not present!");
        }
        StringBuilder sb = new StringBuilder();
        int numMoves = ((String)data.get(KEY_GAME_MOVE)).charAt(0) - 48;
        if (numMoves < 0 || 9 < numMoves) {
            throw new Exception("Invalid amount of moves: " + numMoves);
        }
        int[] p1moves = new int[9];
        int[] p2moves = new int[9];
        char[] readMoves = ((String)data.get(KEY_P1_MOVES)).toCharArray();
        if (readMoves.length != numMoves) {
            throw new Exception("Player 1 has " + readMoves.length + " moves but game has " + numMoves);
        }
        for (i = 0; i < 9; ++i) {
            if (i < numMoves) {
                p1moves[i] = readMoves[i];
                if (readMoves[i] >= '\u0000' && '\u0005' >= readMoves[i]) continue;
                throw new Exception("Invalid move saved for player 1 move " + i + ": " + readMoves[i]);
            }
            p1moves[i] = -1;
        }
        readMoves = ((String)data.get(KEY_P2_MOVES)).toCharArray();
        if (readMoves.length != numMoves) {
            throw new Exception("Player 2 has " + readMoves.length + " moves but game has " + numMoves);
        }
        for (i = 0; i < 9; ++i) {
            if (i < numMoves) {
                p2moves[i] = readMoves[i];
                if (readMoves[i] >= '\u0000' && '\u0005' >= readMoves[i]) continue;
                throw new Exception("Invalid move saved for player 2 move " + i + ": " + readMoves[i]);
            }
            p2moves[i] = -1;
        }
        ArrayList<Player> players = new ArrayList<Player>();
        ArrayList<Database> databases = new ArrayList<Database>();
        EngineSourceManager.collectResources(players, databases, new Player[0]);
        String pname = (String)data.get(KEY_P1_NAME);
        if ("Human".equals(pname)) {
            game.p1 = HumanPlayer.INSTANCE;
        } else {
            path = (String)data.get(KEY_P1_PATH);
            if (path != null && path.isEmpty()) {
                path = null;
            }
            game.p1 = null;
            for (Player player : players) {
                if (!pname.equals(player.getName()) || !Objects.equals(path, player.getPath())) continue;
                game.p1 = player;
                break;
            }
            if (game.p1 == null) {
                throw new Exception("Player 1 " + path + "/" + pname + " is not in the location list");
            }
            game.db1 = null;
            dbname = (String)data.get(KEY_DB1_NAME);
            if (dbname != null) {
                path = (String)data.get(KEY_DB1_PATH);
                if (path != null && path.isEmpty()) {
                    path = null;
                }
                for (Database database : databases) {
                    if (!dbname.equals(database.getName()) || !Objects.equals(path, database.getPath())) continue;
                    game.db1 = database;
                    break;
                }
                if (game.db1 == null) {
                    throw new Exception("Database 1 " + path + "/" + dbname + " is not in the location list");
                }
            }
        }
        pname = (String)data.get(KEY_P2_NAME);
        if ("Human".equals(pname)) {
            game.p2 = HumanPlayer.INSTANCE;
        } else {
            path = (String)data.get(KEY_P2_PATH);
            if (path != null && path.isEmpty()) {
                path = null;
            }
            game.p2 = null;
            for (Player player : players) {
                if (!pname.equals(player.getName()) || !Objects.equals(path, player.getPath())) continue;
                game.p2 = player;
                break;
            }
            if (game.p2 == null) {
                throw new Exception("Player 2 " + path + "/" + pname + " is not in the location list");
            }
            game.db2 = null;
            dbname = (String)data.get(KEY_DB2_NAME);
            if (dbname != null) {
                path = (String)data.get(KEY_DB2_PATH);
                if (path != null && path.isEmpty()) {
                    path = null;
                }
                for (Database database : databases) {
                    if (!dbname.equals(database.getName()) || !Objects.equals(path, database.getPath())) continue;
                    game.db2 = database;
                    break;
                }
                if (game.db2 == null) {
                    throw new Exception("Database 2 " + path + "/" + dbname + " is not in the location list");
                }
            }
        }
        game.p1.load();
        game.p2.load();
        if (game.db1 != null) {
            game.db1.load();
        }
        if (game.db2 != null) {
            game.db2.load();
        }
        game.startNewGame();
        for (int i3 = 0; i3 < 9; ++i3) {
            HumanPlayer.chosenElement[0] = p1moves[i3];
            HumanPlayer.chosenElement[1] = p2moves[i3];
            game.update();
        }
        if (game.data.isFinished()) {
            String p2score;
            String p1score = (String)data.get(KEY_P1_SCORE);
            if (p1score != null && !p1score.equals(String.valueOf(game.data.getScore(0)))) {
                sb.append("Player 1 score deviates: saved game value is " + p1score + ", now it's " + game.data.getScore(0));
                sb.append("\n");
            }
            if ((p2score = (String)data.get(KEY_P2_SCORE)) != null && !p2score.equals(String.valueOf(game.data.getScore(1)))) {
                sb.append("Player 2 score deviates: saved game value is " + p2score + ", now it's " + game.data.getScore(1));
                sb.append("\n");
            }
        }
        return sb.toString();
    }
}

