/*
 * Decompiled with CFR 0.152.
 */
package engines.nuwanisl;

import backend.ACMain;
import backend.Database;
import backend.Game;
import backend.Player;
import engines.nuwanisl.DB;
import engines.nuwanisl.NuwaniSL;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import resources.EngineSourceManager;

public class NuwaniSLTraining {
    static int wins;
    static int losses;
    static int ties;

    public static void main(String[] args) throws Exception {
        int i;
        int t;
        int m;
        int GENS = 35;
        ACMain.main();
        DB.Variant originalDbEngines = DB.forEngines;
        DB.forEngines = new DB.Variant();
        ArrayList<Player> playerList = new ArrayList<Player>();
        ArrayList<Database> databases = new ArrayList<Database>();
        EngineSourceManager.collectResources(playerList, databases, new Player[0]);
        int[][] myScore = new int[playerList.size()][GENS];
        int[][] theirScore = new int[playerList.size()][GENS];
        int engines = 0;
        Game g = new Game();
        for (int i2 = 0; i2 < GENS; ++i2) {
            DB.Variant cleanGenerationEngine = DB.forEngines.copy();
            DB.Variant buildingGenerationEngine = DB.forEngines.copy();
            ties = 0;
            losses = 0;
            wins = 0;
            int idx = 0;
            Iterator<Player> r = playerList.iterator();
            while (r.hasNext()) {
                Player player = r.next();
                try {
                    int j;
                    player.load();
                    DB.forEngines = cleanGenerationEngine.copy();
                    g.p1 = NuwaniSL.INSTANCE;
                    g.p2 = player;
                    g.db2 = EngineSourceManager.tryFindDatabaseFor(player, databases);
                    g.startNewGame();
                    myScore[idx][i2] = m = g.data.getScore(0);
                    theirScore[idx][i2] = t = g.data.getScore(1);
                    ++idx;
                    if (m > t) {
                        ++wins;
                    } else if (m == t) {
                        ++ties;
                    } else {
                        ++losses;
                    }
                    for (j = 0; j < cleanGenerationEngine.numData; ++j) {
                        int n = j * 2 + 1;
                        DB.forEngines.data[n] = DB.forEngines.data[n] - cleanGenerationEngine.data[j * 2 + 1];
                    }
                    block5: for (j = 0; j < DB.forEngines.numData; ++j) {
                        for (int k = 0; k < buildingGenerationEngine.numData; ++k) {
                            if (DB.forEngines.data[j * 2] != buildingGenerationEngine.data[k * 2]) continue;
                            int n = k * 2 + 1;
                            buildingGenerationEngine.data[n] = buildingGenerationEngine.data[n] + DB.forEngines.data[j * 2 + 1];
                            continue block5;
                        }
                        buildingGenerationEngine.data[buildingGenerationEngine.numData * 2] = DB.forEngines.data[j * 2];
                        buildingGenerationEngine.data[buildingGenerationEngine.numData * 2 + 1] = DB.forEngines.data[j * 2 + 1];
                        ++buildingGenerationEngine.numData;
                    }
                }
                catch (Exception e1) {
                    r.remove();
                    System.err.println(player.getPath() + "/" + player.getName());
                    e1.printStackTrace();
                }
            }
            engines = idx;
            System.out.printf("win %d lose %d tie %d = %.02f <-> %.02f%n", wins, losses, ties, Float.valueOf(((float)wins + (float)ties / 2.0f) / (float)(wins + losses + ties)), Float.valueOf((float)wins + (float)ties / 2.0f - (float)(wins + losses + ties) / 2.0f));
            DB.forEngines = buildingGenerationEngine;
        }
        DB.forEngines = originalDbEngines;
        ArrayList<Object> lines = new ArrayList<Object>();
        ArrayList<Object> lines2 = new ArrayList<Object>();
        lines.add("<table style='text-align:center' border='1'>");
        lines.add("<tr>");
        lines.add("<th></th>");
        for (i = 0; i < GENS; ++i) {
            lines.add("<th style='background:#99f'>Gen " + i + "</th>");
        }
        lines.add("</tr>");
        lines2.addAll(lines);
        for (i = 0; i < engines; ++i) {
            String name = playerList.get(i).getName().replace("<", "&lt;");
            lines.add("<tr><td style='background:#99f'>" + name + "</td>");
            lines2.add("<tr><td style='background:#99f'>" + name + "</td>");
            int last = 0;
            for (int j = 0; j < GENS; ++j) {
                m = myScore[i][j];
                t = theirScore[i][j];
                if (m > t) {
                    lines.add("<td style='background:#9f9'>");
                } else if (m < t) {
                    lines.add("<td style='background:#f99'>");
                } else {
                    lines.add("<td style='background:#ccc'>");
                }
                lines.add(m + " - " + t + "</td>");
                int now = m - t;
                if (j == 0 || now == last) {
                    lines2.add("<td style='background:#ccc'>");
                } else if (now > last) {
                    lines2.add("<td style='background:#9f9'>");
                } else if (now < last) {
                    lines2.add("<td style='background:#f99'>");
                }
                last = now;
                lines2.add(m + " - " + t + "</td>");
            }
            lines.add("</tr>");
            lines2.add("</tr>");
        }
        lines.add("</table>");
        lines2.add("</table>");
        List<File> locations = EngineSourceManager.getLocations();
        if (!locations.isEmpty()) {
            Files.write(new File(locations.get(0), "nuwanislstats.html").toPath(), lines, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            Files.write(new File(locations.get(0), "nuwanislstats2.html").toPath(), lines2, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        }
    }
}

