/*
 * Decompiled with CFR 0.152.
 */
package engines.nuwanisl;

import backend.ACMain;
import backend.Database;
import backend.Game;
import backend.Player;
import engines.nuwanisl.DB;
import engines.nuwanisl.NuwaniSL;
import java.util.ArrayList;
import java.util.Iterator;
import resources.EngineSourceManager;

public class NuwaniSLTest {
    static int wins;
    static int losses;
    static int ties;

    public static void main(String[] args) throws Exception {
        ACMain.main();
        DB.Variant originalDbEngines = DB.forEngines;
        DB.forEngines = new DB.Variant();
        ArrayList<Player> playerList = new ArrayList<Player>();
        ArrayList<Database> databases = new ArrayList<Database>();
        EngineSourceManager.collectResources(playerList, databases, new Player[0]);
        ties = 0;
        losses = 0;
        wins = 0;
        Game g = new Game();
        Iterator<Player> r = playerList.iterator();
        while (r.hasNext()) {
            Player player = r.next();
            try {
                player.load();
                DB.forEngines = originalDbEngines.copy();
                g.p1 = NuwaniSL.INSTANCE;
                g.p2 = player;
                g.db2 = EngineSourceManager.tryFindDatabaseFor(player, databases);
                g.startNewGame();
                int m = g.data.getScore(0);
                int t = g.data.getScore(1);
                System.out.printf("%s - %s: %d-%d ", g.data.getPlayerName(0), g.data.getPlayerName(1), m, t);
                if (m > t) {
                    System.out.println("win");
                    ++wins;
                    continue;
                }
                if (m < t) {
                    System.out.println("lose");
                    ++losses;
                    continue;
                }
                System.out.println("tie");
                ++ties;
            }
            catch (Exception e1) {
                r.remove();
                System.err.println(player.getPath() + "/" + player.getName());
                e1.printStackTrace();
            }
        }
        System.out.printf("%nwins %d losses %d ties %d%n", wins, losses, ties);
        DB.forEngines = originalDbEngines;
    }
}

