/*
 * Decompiled with CFR 0.152.
 */
package engines.nuwanisl;

import common.ErrorHandler;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.List;
import resources.EngineSourceManager;

class DB {
    private static byte MARK_START_ENGINE_DATA = (byte)8;
    private static byte MARK_START_PLAYER_DATA = (byte)7;
    private static byte MARK_END_DATA = (byte)6;
    private static String DB_FILE = "nuwani.sl";
    private static String DB_BACKUP_FILE = "nuwani.sl.backup";
    static Variant forEngines = new Variant();
    static Variant forPlayers = new Variant();

    DB() {
    }

    static void init() {
        DB.reset();
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            File databaseFile = DB.findDatabaseFile();
            if (databaseFile != null) {
                DB.writeDatabase(databaseFile);
            } else {
                List<File> locations = EngineSourceManager.getLocations();
                if (!locations.isEmpty()) {
                    DB.writeDatabase(new File(locations.get(0), "nuwani.sl"));
                }
            }
        }));
        File databaseFile = DB.findDatabaseFile();
        if (databaseFile != null) {
            DB.readDatabase(databaseFile);
        }
    }

    static void reset() {
        DB.forPlayers.numData = 0;
        DB.forEngines.numData = 0;
    }

    private static File findDatabaseFile() {
        for (File dir : EngineSourceManager.getLocations()) {
            File f = new File(dir, DB_FILE);
            if (!f.exists() || !f.isFile()) continue;
            return f;
        }
        return null;
    }

    private static void simpleBackupDatabase(File databaseFile) {
        File copy = new File(databaseFile.getParentFile(), DB_BACKUP_FILE);
        try {
            Files.copy(databaseFile.toPath(), copy.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            ErrorHandler.handler.handleException(e, "Failed to make a backup of the Nuwani SL database");
        }
    }

    private static void readDatabase(File databaseFile) {
        DB.reset();
        DB.simpleBackupDatabase(databaseFile);
        try (FileInputStream in = new FileInputStream(databaseFile);){
            while (true) {
                int data;
                if ((data = in.read()) == -1) {
                    return;
                }
                if (data == MARK_START_ENGINE_DATA) {
                    DB.readDatabaseVariant(in, forEngines);
                    continue;
                }
                if (data == MARK_START_PLAYER_DATA) {
                    DB.readDatabaseVariant(in, forPlayers);
                    continue;
                }
                System.out.printf("wrong data in SL db: %02X%n", data);
            }
        }
        catch (IOException e) {
            ErrorHandler.handler.handleException(e);
            return;
        }
    }

    private static void readDatabaseVariant(InputStream in, Variant variant) throws IOException {
        int b = 0;
        int a = 0;
        int count = 0;
        while (true) {
            int data;
            if ((data = in.read()) == -1) {
                return;
            }
            if (count == 0 && data == MARK_END_DATA) break;
            if (count < 4) {
                a |= (data & 0xFF) << count * 8;
            } else if (count < 8) {
                b |= (data & 0xFF) << count * 8;
            }
            if (++count != 8) continue;
            variant.data[variant.numData * 2] = a;
            variant.data[variant.numData * 2 + 1] = b;
            ++variant.numData;
            count = 0;
            b = 0;
            a = 0;
        }
    }

    private static void writeDatabase(File databaseFile) {
        try (FileOutputStream out = new FileOutputStream(databaseFile);){
            out.write(MARK_START_ENGINE_DATA);
            DB.writeDatabaseVariant(out, forEngines);
            out.write(MARK_END_DATA);
            out.write(MARK_START_PLAYER_DATA);
            DB.writeDatabaseVariant(out, forPlayers);
            out.write(MARK_END_DATA);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void writeDatabaseVariant(OutputStream out, Variant variant) throws IOException {
        for (int i = 0; i < variant.numData; ++i) {
            int a = variant.data[i * 2];
            int b = variant.data[i * 2 + 1];
            out.write(a & 0xFF);
            out.write(a >>> 8 & 0xFF);
            out.write(a >>> 16 & 0xFF);
            out.write(a >>> 24 & 0xFF);
            out.write(b & 0xFF);
            out.write(b >>> 8 & 0xFF);
            out.write(b >>> 16 & 0xFF);
            out.write(b >>> 24 & 0xFF);
        }
    }

    static class Variant {
        int[] data = new int[32768];
        int numData;

        Variant() {
        }

        Variant copy() {
            Variant v = new Variant();
            System.arraycopy(this.data, 0, v.data, 0, this.data.length);
            v.numData = this.numData;
            return v;
        }

        int indexFor(int value, int mask) {
            if (mask == -1) {
                for (int i = 0; i < this.numData; ++i) {
                    if (this.data[i * 2] != value) continue;
                    return i * 2;
                }
            } else {
                for (int i = 0; i < this.numData; ++i) {
                    if ((this.data[i * 2] & mask) != value) continue;
                    return i * 2;
                }
            }
            return -1;
        }
    }
}

