/*
 * Decompiled with CFR 0.152.
 */
package engines.elephant;

import backend.Database;
import backend.Game;
import backend.Player;
import backend.ResourceType;
import common.Constants;
import engines.elephant.DB;

public class Elephant
extends Player {
    public static final Elephant INSTANCE = new Elephant();
    public static int loseScoreFactor = 5;
    private static boolean verbose = System.getProperty("nuwanisl.verbose") != null;

    public static void init() {
        String loseScoreFactorProp = System.getProperty("nuwanisl.losescorefactor");
        if (loseScoreFactorProp != null) {
            loseScoreFactor = Integer.parseInt(loseScoreFactorProp);
        }
        DB.init();
    }

    private static int[] calculateNextDepthUsages(int value, DB.Variant variant, int movesDone) {
        int[] nextDepthUsages = new int[]{0, 0, 0, 0};
        if (movesDone == 0) {
            for (int i = 0; i < variant.numData; ++i) {
                int opponentNextDepth;
                int n = opponentNextDepth = variant.data[i * 2] & 3;
                nextDepthUsages[n] = nextDepthUsages[n] + variant.data[i * 2 + 1];
            }
        } else {
            int mask = -1 >>> 32 - movesDone * 4;
            for (int i = 0; i < variant.numData; ++i) {
                int j;
                if ((variant.data[i * 2] & mask) != value) continue;
                int opponentNextDepth = variant.data[i * 2] >> movesDone * 4 & 3;
                int amountUsage = variant.data[i * 2 + 1];
                int n = opponentNextDepth;
                nextDepthUsages[n] = nextDepthUsages[n] + amountUsage;
                if (!verbose) continue;
                System.out.printf("found enemy's pattern: (depths [", new Object[0]);
                for (j = 0; j < movesDone; ++j) {
                    if (j != 0) {
                        System.out.printf(" ", new Object[0]);
                    }
                    System.out.printf("%d", variant.data[i * 2] >> j * 4 & 3);
                }
                System.out.printf("]", new Object[0]);
                for (j = movesDone; j < 7; ++j) {
                    System.out.printf(" %d", variant.data[i * 2] >> j * 4 & 3);
                }
                System.out.printf("), this pattern was seen %d times%n", amountUsage);
            }
        }
        if (verbose) {
            System.out.printf("enemy next depth usages: 0x%d 1x%d 2x%d 3x%d%n", nextDepthUsages[0], nextDepthUsages[1], nextDepthUsages[2], nextDepthUsages[3]);
        }
        return nextDepthUsages;
    }

    private DB.Variant getDb(int p, Game.Data gamedata) {
        return DB.forEngines;
    }

    @Override
    public ResourceType getType() {
        return ResourceType.BUILTIN;
    }

    @Override
    public String getPath() {
        return null;
    }

    @Override
    public String getName() {
        return "Elephant";
    }

    @Override
    public int doMove(int myNumber, Database _unuseddb, Game.Data gamedata) {
        int theirNumber = myNumber ^ 1;
        DB.Variant db = this.getDb(myNumber, gamedata);
        int currentMove = gamedata.getCurrentMove();
        if (currentMove == 0) {
            return 4;
        }
        if (verbose) {
            System.out.printf("%ncurrent (0-based) move: %d%n", currentMove);
        }
        int movesDone = currentMove - 1;
        int[] myPlayedElements = gamedata.getMoves(myNumber);
        int[] theirPlayedElements = gamedata.getMoves(theirNumber);
        int value = this.value(myPlayedElements, theirPlayedElements, movesDone);
        int[] myElementsLeft = gamedata.getElementsLeft(myNumber);
        int myPreviousElement = myPlayedElements[currentMove - 1];
        int[] nextDepthUsages = Elephant.calculateNextDepthUsages(value, db, movesDone);
        int[] myMoveScores = new int[4];
        for (int myNext = 0; myNext < 4; ++myNext) {
            if (myElementsLeft[myNext] > 0) {
                if (verbose) {
                    System.out.printf("- if I would play %c, then%n", Character.valueOf(Constants.CHARELEMENTS[myNext]));
                }
                for (int j = 0; j < 4; ++j) {
                    int score;
                    int theirNext = myPreviousElement + j;
                    if (theirNext >= 4) {
                        theirNext -= 4;
                    }
                    int moveScore = (score = Constants.RESULTMATRIX[myNext][theirNext]) > 0 ? nextDepthUsages[j] : (score < 0 ? -loseScoreFactor * nextDepthUsages[j] : 0);
                    int n = myNext;
                    myMoveScores[n] = myMoveScores[n] + moveScore;
                    if (!verbose) continue;
                    System.out.printf("  they used depth %d (=%c) for %d times * score %d = %d%n", j, Character.valueOf(Constants.CHARELEMENTS[theirNext]), nextDepthUsages[j], score, moveScore);
                }
                continue;
            }
            if (!verbose) continue;
            System.out.printf("- I can't play %c, none left%n", Character.valueOf(Constants.CHARELEMENTS[myNext]));
        }
        if (verbose) {
            System.out.printf("MY SCORE IF I PLAY ELEMENT: %c=%d %c=%d %c=%d %c=%d%n", Character.valueOf(Constants.CHARELEMENTS[0]), myMoveScores[0], Character.valueOf(Constants.CHARELEMENTS[1]), myMoveScores[1], Character.valueOf(Constants.CHARELEMENTS[2]), myMoveScores[2], Character.valueOf(Constants.CHARELEMENTS[3]), myMoveScores[3]);
        }
        int maxValueIndex = 0;
        for (int j = 0; j < 4; ++j) {
            int maxValue = Integer.MIN_VALUE;
            for (int i = 0; i < 4; ++i) {
                if (myMoveScores[i] <= maxValue) continue;
                maxValue = myMoveScores[i];
                maxValueIndex = i;
            }
            if (verbose) {
                System.out.printf("best score is move %c with score %d%n", Character.valueOf(Constants.CHARELEMENTS[maxValueIndex]), maxValue);
            }
            if (myElementsLeft[maxValueIndex] > 0) {
                return maxValueIndex;
            }
            if (verbose) {
                System.out.println("I don't have this element");
            }
            myMoveScores[maxValueIndex] = Integer.MIN_VALUE;
        }
        return 0;
    }

    @Override
    public void onGameEnd(int myNumber, Database _unuseddb, Game.Data gamedata) {
        int[] theirPlayedElements;
        int[] myPlayedElements;
        int value;
        int theirNumber = myNumber ^ 1;
        DB.Variant db = this.getDb(myNumber, gamedata);
        int index = db.indexFor(value = this.value(myPlayedElements = gamedata.getMoves(myNumber), theirPlayedElements = gamedata.getMoves(theirNumber), 7), -1);
        if (index != -1) {
            int n = index + 1;
            db.data[n] = db.data[n] + 1;
        } else {
            index = db.numData * 2;
            db.data[index] = value;
            db.data[index + 1] = 1;
            ++db.numData;
        }
        if (verbose) {
            System.out.println();
            System.out.println("END ANALYSIS");
            for (int i = 1; i < 7; ++i) {
                int myPrev = myPlayedElements[i - 1];
                int theirCurrent = theirPlayedElements[i];
                System.out.printf("(0-based) move %d: my previous: %c their current: %c depth %d%n", i, Character.valueOf(Constants.CHARELEMENTS[myPrev]), Character.valueOf(Constants.CHARELEMENTS[theirCurrent]), this.depth(myPrev, theirCurrent));
            }
        }
    }

    private int value(int[] myMoves, int[] otherMoves, int movesDone) {
        int value = 0;
        for (int i = 0; i < movesDone; ++i) {
            value |= this.depth(myMoves[i], otherMoves[i + 1]) << i * 4;
        }
        return value;
    }

    private int depth(int myPrevious, int other) {
        int d;
        for (d = other - myPrevious; d < 0; d += 4) {
        }
        while (d >= 4) {
            d -= 4;
        }
        return d;
    }

    @Override
    public boolean canUseDatabase() {
        return false;
    }
}

