/*
 * Decompiled with CFR 0.152.
 */
package engines;

import common.Constants;
import engines.FixedEngine;
import java.io.File;
import resources.Resources;

public class FileFixedEngine
extends FixedEngine {
    private final File file;

    public FileFixedEngine(File file) {
        super(file.getName());
        this.file = file;
    }

    @Override
    public String getPath() {
        return this.file.getParentFile().getAbsolutePath();
    }

    @Override
    public void load() throws Exception {
        int i;
        byte[] data = new byte[9];
        int read = Resources.readFileCharacters(this.file, data, 8);
        if (read < 8) {
            new Exception("need at least 8 elements, got " + read);
        }
        this.moves = new int[9];
        byte[] elementsneeded = new byte[]{2, 2, 2, 2, 1};
        byte[] elementsused = new byte[5];
        for (i = 0; i < 8; ++i) {
            int move = data[i] | 0x20;
            switch (move) {
                case 119: {
                    move = 0;
                    break;
                }
                case 118: {
                    move = 1;
                    break;
                }
                case 97: {
                    move = 2;
                    break;
                }
                case 108: {
                    move = 3;
                    break;
                }
                case 100: {
                    move = 4;
                    break;
                }
                default: {
                    throw new Exception("invalid element: '" + (char)move + "'");
                }
            }
            this.moves[i] = move;
            int n = move;
            elementsused[n] = (byte)(elementsused[n] + 1);
        }
        for (i = 0; i < 5; i = (int)((byte)(i + 1))) {
            if (elementsused[i] >= elementsneeded[i]) continue;
            data[8] = i;
            int n = i;
            elementsused[n] = (byte)(elementsused[n] + 1);
            this.moves[8] = i;
            break;
        }
        for (i = 0; i < 5; i = (int)((byte)(i + 1))) {
            if (elementsused[i] == elementsneeded[i]) continue;
            String msg = String.format("need %d of %c, got only %d", elementsneeded[i], Character.valueOf(Constants.CHARELEMENTS[i]), elementsused[i]);
            throw new Exception(msg);
        }
    }
}

