/*
 * Decompiled with CFR 0.152.
 */
package engines;

import engines.DepthEngine;
import java.io.File;
import resources.Resources;

public class FileDepthEngine
extends DepthEngine {
    private final File file;

    public FileDepthEngine(File file) {
        super(file.getName());
        this.file = file;
    }

    @Override
    public String getPath() {
        return this.file.getParentFile().getAbsolutePath();
    }

    @Override
    public void load() throws Exception {
        this.depths = new byte[9];
        int size = Resources.readFileCharacters(this.file, this.depths, 9);
        if (size < 8) {
            throw new Exception("need at least 8 depths, got " + size);
        }
        if (size < 9) {
            this.depths[8] = 48;
        }
        int i = 0;
        while (i < 9) {
            if (this.depths[i] < 48 || 57 < this.depths[i]) {
                throw new Exception("invalid depth: " + (char)(this.depths[i] & 0xFF));
            }
            int n = i++;
            this.depths[n] = (byte)(this.depths[n] - 48);
        }
    }
}

