/*
 * Decompiled with CFR 0.152.
 */
package engines;

import backend.Database;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;

public class FileDatabase
extends Database {
    private File file;

    public FileDatabase(File file) {
        super(file.getName());
        this.file = file;
    }

    @Override
    public String getPath() {
        return this.file.getParentFile().getAbsolutePath();
    }

    @Override
    public void load() throws Exception {
        this.db = new ArrayList();
        try (FileInputStream in = new FileInputStream(this.file);){
            int c = in.read();
            if ((c & 0xEF) == 239) {
                if (in.read() == -1) {
                    return;
                }
                if (in.read() == -1) {
                    return;
                }
                c = in.read();
            }
            if (c == -1) {
                return;
            }
            int currententry = 0x77777777;
            boolean cleanexit = false;
            while (true) {
                if (c == 36) {
                    if (currententry != 0x77777777) {
                        throw new Exception("unexpected NextDbEntry");
                    }
                } else if (c == 167) {
                    if (currententry == 0x77777777) {
                        throw new Exception("invalid, expected ElementSequence");
                    }
                    this.db.add(currententry << 4 | this.ctoe(in.read()) & 0xF);
                    currententry = 0x77777777;
                    cleanexit = true;
                } else {
                    if (c == 194) {
                        c = in.read();
                        if (c != -1) continue;
                        throw new Exception("unexpected EOF");
                    }
                    currententry <<= 4;
                    currententry |= this.ctoe(c) & 0xF;
                }
                if ((c = in.read()) == -1) {
                    if (!cleanexit) {
                        throw new Exception("unexpected EOF");
                    }
                    break;
                }
                cleanexit = false;
            }
        }
    }

    private int ctoe(int in) throws Exception {
        switch (in | 0x20) {
            case -1: {
                throw new Exception("unexpected EOF");
            }
            case 119: {
                return 0;
            }
            case 118: {
                return 1;
            }
            case 97: {
                return 2;
            }
            case 108: {
                return 3;
            }
            case 100: {
                return 4;
            }
        }
        throw new Exception("invalid element: " + in);
    }
}

