/*
 * Decompiled with CFR 0.152.
 */
package engines;

import backend.Database;
import backend.Game;
import backend.Player;
import backend.ResourceType;

public class DepthEngine
extends Player {
    private final String name;
    private ResourceType type;
    protected byte[] depths;

    public DepthEngine(String name) {
        this.name = name;
        this.type = ResourceType.DEPTH;
    }

    public DepthEngine(String name, int ... depths) {
        this.name = name;
        this.type = ResourceType.BUILTIN;
        this.depths = new byte[9];
        for (int i = 0; i < depths.length; ++i) {
            this.depths[i] = (byte)depths[i];
        }
    }

    @Override
    public ResourceType getType() {
        return this.type;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getPath() {
        return null;
    }

    @Override
    public int doMove(int p, Database db, Game.Data data) {
        int dbres;
        int move = data.getCurrentMove();
        if (move == 0) {
            return 4;
        }
        if (move == 8) {
            for (int i = 0; i < 5; ++i) {
                if (data.getElementsLeft(p, i) <= 0) continue;
                return i;
            }
        }
        if (db != null && (dbres = db.findEntry(data, p)) != -1 && data.getElementsLeft(p, dbres) > 0) {
            return dbres;
        }
        int element = data.getMove(p ^ 1, move - 1);
        if (element == 4) {
            element = 3;
        }
        int[] onedepth = new int[5];
        onedepth[0] = 3;
        onedepth[1] = 0;
        onedepth[2] = 1;
        onedepth[3] = 2;
        int i = (this.depths[move] + 4) % 4;
        while (i-- > 0 || data.getElementsLeft(p, element) == 0) {
            element = onedepth[element];
        }
        return element;
    }

    @Override
    public boolean canUseDatabase() {
        return true;
    }
}

