/*
 * Decompiled with CFR 0.152.
 */
package backend;

import backend.Game;
import backend.Resource;
import backend.ResourceType;
import java.util.List;

public class Database
implements Resource {
    private final String name;
    protected List<Integer> db;

    public Database(String name) {
        this.name = name;
    }

    public Database(String name, List<Integer> db) {
        this.name = name;
        this.db = db;
    }

    public void load() throws Exception {
    }

    @Override
    public ResourceType getType() {
        return ResourceType.DATABASE;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getPath() {
        return null;
    }

    public int findEntry(Game.Data data, int playerNumber) {
        int currentMove = data.getCurrentMove();
        if (currentMove == 0 || 7 < currentMove) {
            return -1;
        }
        int p = playerNumber ^ 1;
        int hash = 0x77777777;
        for (int i = 0; i < currentMove; ++i) {
            hash = hash << 4 | data.getMove(p, i) & 0xF;
        }
        hash <<= 4;
        for (int v : this.db) {
            if ((v & 0xFFFFFFF0) != hash) continue;
            return v & 0xF;
        }
        return -1;
    }
}

